<?php
require_once '../config/config.php';

if (getUserRole() !== 'warga') {
    redirect('../dashboard.php');
}

$db = Database::getInstance()->getConnection();

// Handle update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $latitude = floatval($_POST['latitude'] ?? 0);
    $longitude = floatval($_POST['longitude'] ?? 0);
    $email = sanitize($_POST['email'] ?? '');
    $no_hp = sanitize($_POST['no_hp'] ?? '');
    
    $stmt = $db->prepare("UPDATE users SET latitude = ?, longitude = ?, email = ?, no_hp = ? WHERE id = ?");
    if ($stmt->execute([$latitude, $longitude, $email, $no_hp, $_SESSION['user_id']])) {
        $_SESSION['success'] = 'Profil berhasil diupdate';
        redirect('../dashboard.php');
    } else {
        $_SESSION['error'] = 'Gagal update profil';
    }
}

// Get user data
$stmt = $db->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil Saya - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-user"></i> Profil Saya</h1>
                <p>Kelola informasi dan lokasi GPS Anda</p>
            </div>
        </header>

        <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
        </div>
        <?php endif; ?>

        <div class="content-section">
            <form method="POST" class="form-container">
                <div class="form-group">
                    <label>Username</label>
                    <input type="text" value="<?php echo htmlspecialchars($user['username']); ?>" readonly style="background: #f5f5f5;">
                </div>
                <div class="form-group">
                    <label>Nama Lengkap</label>
                    <input type="text" value="<?php echo htmlspecialchars($user['nama_lengkap']); ?>" readonly style="background: #f5f5f5;">
                </div>
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label>No. HP</label>
                    <input type="text" name="no_hp" value="<?php echo htmlspecialchars($user['no_hp'] ?? ''); ?>">
                </div>
                
                <div class="form-group">
                    <label>Lokasi GPS</label>
                    <div id="profileMap" style="height: 300px; margin-top: 10px; border-radius: 10px;"></div>
                    <small style="color: #666; display: block; margin-top: 5px;">
                        <i class="fas fa-info-circle"></i> Klik di peta atau gunakan tombol untuk mengambil koordinat GPS
                    </small>
                    <button type="button" class="btn btn-sm btn-primary" onclick="getProfileLocation()" style="margin-top: 10px;">
                        <i class="fas fa-map-marker-alt"></i> Ambil Koordinat GPS
                    </button>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Latitude</label>
                        <input type="number" step="any" name="latitude" id="profile_latitude" value="<?php echo $user['latitude'] ?? ''; ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Longitude</label>
                        <input type="number" step="any" name="longitude" id="profile_longitude" value="<?php echo $user['longitude'] ?? ''; ?>" required>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">
                    <i class="fas fa-save"></i> Simpan Perubahan
                </button>
            </form>
        </div>
    </main>

    <script src="../assets/js/main.js"></script>
    <script>
    let profileMap, profileMarker;
    
    // Initialize map
    const initLat = <?php echo $user['latitude'] ?? -7.7956; ?>;
    const initLng = <?php echo $user['longitude'] ?? 110.3695; ?>;
    
    profileMap = L.map('profileMap').setView([initLat, initLng], 13);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(profileMap);
    
    if (initLat && initLng) {
        profileMarker = L.marker([initLat, initLng]).addTo(profileMap);
    }
    
    profileMap.on('click', function(e) {
        const lat = e.latlng.lat;
        const lng = e.latlng.lng;
        document.getElementById('profile_latitude').value = lat;
        document.getElementById('profile_longitude').value = lng;
        
        if (profileMarker) {
            profileMap.removeLayer(profileMarker);
        }
        profileMarker = L.marker([lat, lng]).addTo(profileMap);
    });
    
    function getProfileLocation() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(
                function(position) {
                    const lat = position.coords.latitude;
                    const lng = position.coords.longitude;
                    
                    document.getElementById('profile_latitude').value = lat;
                    document.getElementById('profile_longitude').value = lng;
                    
                    profileMap.setView([lat, lng], 15);
                    if (profileMarker) {
                        profileMap.removeLayer(profileMarker);
                    }
                    profileMarker = L.marker([lat, lng]).addTo(profileMap);
                    
                    showToast('Koordinat GPS berhasil diambil', 'success');
                },
                function(error) {
                    showToast('Gagal mengambil koordinat: ' + error.message, 'danger');
                }
            );
        } else {
            showToast('GPS tidak didukung di perangkat ini', 'warning');
        }
    }
    </script>
</body>
</html>

